/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute.serialization;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierSerializer;
import dev.toma.gunsrpg.common.attribute.AttributeOps;
import dev.toma.gunsrpg.common.attribute.ExpiringModifier;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class ExpiringModifierSerializer
implements IModifierSerializer<ExpiringModifier> {
    private static final ResourceLocation UID = GunsRPG.makeResource("expiring");

    @Override
    public ResourceLocation getSerializerUid() {
        return UID;
    }

    @Override
    public void toNbtStructure(ExpiringModifier modifier, CompoundNBT data) {
        data.func_186854_a("uid", modifier.getUid());
        data.func_74778_a("op", modifier.getOperation().getId().toString());
        data.func_74780_a("value", modifier.getModifierValue());
        data.func_74768_a("initialTime", modifier.getInitialTime());
        data.func_74768_a("timeLeft", modifier.getTimeLeft());
    }

    @Override
    public ExpiringModifier fromNbtStructure(CompoundNBT data) {
        UUID uuid = data.func_186857_a("uid");
        ResourceLocation opKey = new ResourceLocation(data.func_74779_i("op"));
        double value = data.func_74769_h("value");
        IModifierOp op = AttributeOps.find(opKey);
        int time = data.func_74762_e("initialTime");
        ExpiringModifier modifier = new ExpiringModifier(uuid, op, value, time);
        int timeLeft = data.func_74762_e("timeLeft");
        modifier.setTimeLeft(timeLeft);
        return modifier;
    }
}

